
library IEEE;
use IEEE.STD_LOGIC_1164.all;

use work.cl_types.all;

package CL_DXPX is
   type CL_SEND_M_D8P2 is
      record 
         dummy : bit;
      end record;
   
   type CL_REC_S_D8P2 is
      record 
         dummy   : bit;
   end record;

   type CL_REC_M_D8P2 is
      record 
         dummy  : bit;
      end record;

   type CL_SEND_S_D8P2 is
      record 
         dummy  : bit;
      end record;

   -- Channel Initializations   
   procedure CL_InitSendMstD8P2(
            signal   chan              : out CL_SEND_M_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_InitRecSrvD8P2(
            signal   chan              : out CL_REC_S_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_InitRecMstD8P2(
            signal   chan              : out CL_REC_M_D8P2;
            signal   data_p            : out STD_LOGIC8; 
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_InitSendSrvD8P2(
            signal   chan              : out CL_SEND_S_D8P2;
            signal   data_p            : out STD_LOGIC8; 
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   -- Data transfers
   procedure CL_SendMstD8P2(
            signal   chan              : in CL_SEND_M_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_RecSrvD8P2(
            signal   chan              : in CL_REC_S_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_RecMstD8P2(
            signal   chan              : in CL_REC_M_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_SendSrvD8P2(
            signal   chan              : in CL_SEND_S_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit);

end CL_DXPX;  

package body CL_DXPX is

procedure CL_InitSendMstD8P2(
            signal   chan              : out CL_SEND_M_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;    --STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_p     <= "ZZZZZZZZ";
   data_req_p <= 'Z';
   wait until clk_p'event and clk_p='1';
end CL_InitSendMstD8P2;

procedure CL_InitRecSrvD8P2(
            signal   chan              : out CL_REC_S_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_p     <= "ZZZZZZZZ";
   data_req_p <= 'Z';
   wait until clk_p'event and clk_p='1';
end CL_InitRecSrvD8P2;

procedure CL_InitRecMstD8P2(
            signal   chan              : out CL_REC_M_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_p     <= "ZZZZZZZZ";
   data_req_p <= 'Z';
   wait until clk_p'event and clk_p='1';
end CL_InitRecMstD8P2;

procedure CL_InitSendSrvD8P2(
            signal   chan              : out CL_SEND_S_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_p     <= "ZZZZZZZZ";
   data_req_p <= 'Z';
   wait until clk_p'event and clk_p='1';
end CL_InitSendSrvD8P2;

procedure wait_four_cycles(
            signal   clk_p             : in bit) is 
begin
   wait until clk_p'event and clk_p='1';
   wait until clk_p'event and clk_p='1';
   wait until clk_p'event and clk_p='1';
   wait until clk_p'event and clk_p='1';
end Wait_four_cycles;

procedure wait_two_cycles(
            signal   clk_p             : in bit) is 
begin
   wait until clk_p'event and clk_p='1';
   wait until clk_p'event and clk_p='1';
end wait_two_cycles;

procedure CL_SendMstD8P2(
            signal   chan              : in CL_SEND_M_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_p     <= send_byte;
   data_req_p <= '0';
   
   wait_four_cycles(clk_p);

   data_p     <= "ZZZZZZZZ";
   data_req_p <= 'Z';
   wait_two_cycles(clk_p);
end CL_SendMstD8P2;

procedure CL_RecSrvD8P2(
            signal   chan              : in CL_REC_S_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   wait until clk_p'event and clk_p='1' and data_req_p='0';
   rec_byte   := data_p; 
   wait until clk_p'event and clk_p='1' and data_req_p='Z';
end CL_RecSrvD8P2;   

procedure CL_RecMstD8P2(
            signal   chan              : in CL_REC_M_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   data_req_p <= '0';
   wait_four_cycles(clk_p);
   rec_byte  := data_p;
   data_req_p <= 'Z';
   wait_two_cycles(clk_p);
end CL_RecMstD8P2;

procedure CL_SendSrvD8P2(
            signal   chan              : in CL_SEND_S_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit) is
begin
   wait until clk_p'event and clk_p='1' and data_req_p='0';
   data_p    <= send_byte; 
   wait until clk_p'event and clk_p='1' and data_req_p='Z';
   data_p    <= "ZZZZZZZZ";
   wait until clk_p'event and clk_p='1';
end CL_SendSrvD8P2;

end CL_DXPX;







